//----------------------------------------------------------------------------//
//- CadEinstellungen.pas -----------------------------------------------------//
//----------------------------------------------------------------------------//

//- Beschreibung -------------------------------------------------------------//
// In diesem Formular knnen allgemeine Einstellungen gemacht werden          //
//----------------------------------------------------------------------------//

unit CadEinstellungen;

//------------------------------------------------------------------------------

interface

//------------------------------------------------------------------------------

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, CadBaseDialog, StdCtrls, CaoRegistry, ExtCtrls;

//------------------------------------------------------------------------------

type
  TCaDlgEinstellungen = class(TCaDlgBaseDialog)
    m_BtnSteuerCodes         : TButton;
    m_ChkInitialenDrucken    : TCheckBox;
    m_PanSeparator           : TPanel;
    m_BtnDruckerEinrichten: TButton;
    m_DlgPrint: TPrintDialog;

    //--------------------------------------------------------------------------

    procedure BtnSteuerCodesClick (Sender: TObject);
    procedure FormShow            (Sender: TObject);
    procedure FormCreate          (Sender: TObject);
    procedure FormDestroy         (Sender: TObject);
    procedure FormClose           (Sender: TObject; var Action: TCloseAction);
    procedure BtnDruckerEinrichtenClick(Sender: TObject);

    //--------------------------------------------------------------------------

  private
    m_obRegistry: TCaoRegistry;

  //----------------------------------------------------------------------------

  public

  //----------------------------------------------------------------------------

  end; //  TCaDlgEinstellungen

//------------------------------------------------------------------------------

var
  CaDlgEinstellungen: TCaDlgEinstellungen;

//------------------------------------------------------------------------------

implementation

//------------------------------------------------------------------------------

{$R *.dfm}

//------------------------------------------------------------------------------

uses
  CapSteuerCodes;

//------------------------------------------------------------------------------

procedure TCaDlgEinstellungen.BtnSteuerCodesClick(Sender: TObject);
begin
  inherited;
  CapQrSteuerCodes.Print;
end; // TCaDlgEinstellungen.BtnSteuerCodesClick

//------------------------------------------------------------------------------

procedure TCaDlgEinstellungen.FormShow(Sender: TObject);
begin
  inherited;
  m_ChkInitialenDrucken.Checked := m_obRegistry.ReadInitialenDrucken;
end; // TCaDlgEinstellungen.FormShow

//------------------------------------------------------------------------------

procedure TCaDlgEinstellungen.FormCreate(Sender: TObject);
begin
  inherited;
  m_obRegistry := TCaoRegistry.Create;
end; // TCaDlgEinstellungen.FormCreate

//------------------------------------------------------------------------------

procedure TCaDlgEinstellungen.FormDestroy(Sender: TObject);
begin
  m_obRegistry.Free;
  inherited;
end; // TCaDlgEinstellungen.FormDestroy

//------------------------------------------------------------------------------

procedure TCaDlgEinstellungen.FormClose(Sender    : TObject;
                                        var Action: TCloseAction);
begin
  inherited;
  if ModalResult = mrOk then begin
    m_obRegistry.WriteInitialenDrucken(m_ChkInitialenDrucken.Checked);
  end; // if
end; // TCaDlgEinstellungen.FormClose

//------------------------------------------------------------------------------

procedure TCaDlgEinstellungen.BtnDruckerEinrichtenClick(Sender: TObject);
begin
  inherited;
  m_DlgPrint.Execute;
end; // TCaDlgEinstellungen.BtnDruckerEinrichtenClick

//------------------------------------------------------------------------------

end. // CadEinstellungen
